local super = require "NumberFormatter"

ScaleFormatter = super:new()

local defaults = {
    decimals = 0,
}

local nilDefaults = {
}

function ScaleFormatter:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    return self
end

function ScaleFormatter:getFormatter()
    return NumberStringFormatter:scale()
end

function ScaleFormatter:getArguments()
    return {
        self:getProperty('decimals'),
        1,
    }
end

function ScaleFormatter:getInspectors()
    local list = List:new()
    local inspector, hook
    inspector = Inspector:new{
        type = 'Decimal',
    }
    inspector:addHook(self:getPropertyHook('decimals'), 'decimals')
    list:add(inspector)
    return list
end

return ScaleFormatter
